import firebase from '@firebase/app';
import { K as Ka, C as Cu, M, L as La, W as Wa, G as Ga, H as Ha, Z as Za, e as eh, t as th, s as sh, i as ih, o as oh, c as ch, j as ja, E as Eu, T as Tu, q as qa } from './prebuilt-a55a34ea.js';
import { Component } from '@firebase/component';
import '@firebase/util';
import '@firebase/logger';
import '@firebase/webchannel-wrapper';

const name = "@firebase/firestore";
const version = "2.4.1";

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
const firestoreNamespace = {
    Firestore: Ka,
    GeoPoint: Cu,
    Timestamp: M,
    Blob: La,
    Transaction: Wa,
    WriteBatch: Ga,
    DocumentReference: Ha,
    DocumentSnapshot: Za,
    Query: eh,
    QueryDocumentSnapshot: th,
    QuerySnapshot: sh,
    CollectionReference: ih,
    FieldPath: oh,
    FieldValue: ch,
    setLogLevel: ja,
    CACHE_SIZE_UNLIMITED: Eu
};
/**
 * Configures Firestore as part of the Firebase SDK by calling registerService.
 *
 * @param firebase - The FirebaseNamespace to register Firestore with
 * @param firestoreFactory - A factory function that returns a new Firestore
 *    instance.
 */
function configureForFirebase(firebase, firestoreFactory) {
    firebase.INTERNAL.registerComponent(new Component('firestore', container => {
        const app = container.getProvider('app').getImmediate();
        return firestoreFactory(app, container.getProvider('auth-internal'));
    }, "PUBLIC" /* PUBLIC */).setServiceProps(Object.assign({}, firestoreNamespace)));
}

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Registers the memory-only Firestore build with the components framework.
 */
function registerFirestore(instance) {
    configureForFirebase(instance, (app, auth) => new Ka(app, new Tu(app, auth), new qa()));
    instance.registerVersion(name, version);
}
registerFirestore(firebase);

export { registerFirestore };
//# sourceMappingURL=index.js.map
